package com.team5.aLife.Client;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;

import com.google.gson.Gson;

public class AddDeviceActivity extends Activity{
	
	private Button submit;
	
	private EditText deviceName;
	
	Spinner deviceType;
	
	private Gson gson = new Gson();
	private final String delimiter = "[&]+";
	
	 /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.adddevice_two);
        
        submit = (Button) findViewById(R.id.Submit);
        deviceType = (Spinner) findViewById(R.id.DeviceTypeSpin);
        ArrayAdapter<CharSequence> adapter = ArrayAdapter.createFromResource(
                this, R.array.device_type_names, android.R.layout.simple_spinner_item);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        deviceType.setAdapter(adapter);
        
        deviceName = (EditText) findViewById(R.id.DeviceName);
        //zigbeeAddress = (EditText) findViewById(R.id.ZigbeeAddress);
        //zigbeeStatus = (EditText) findViewById(R.id.ZigbeeStatus);
        //deviceStatus = (EditText) findViewById(R.id.DeviceStatus);
        
        submit.setOnClickListener(connectListener);
        
    }
    
    private View.OnClickListener connectListener = new View.OnClickListener() {

        @Override
        public void onClick(View v) {
        
        	
    	if (deviceName.getText().toString().equals(""))
        {
        	AlertDialog.Builder builder = new AlertDialog.Builder(AddDeviceActivity.this);
        	builder.setMessage("Please put in a valid device name")
        	       .setCancelable(false)
        	       .setPositiveButton("OK", new DialogInterface.OnClickListener() {
        	           public void onClick(DialogInterface dialog, int id) {
        	        	   //RegisterDeviceActivity.this.finish();
        	           }
        	       });
        	AlertDialog alert = builder.create();
        	alert.show();
        }	
    	else {
	        Device newDevice = new Device (0,
	        							   Integer.parseInt(getResources().getStringArray(R.array.device_type_values)[deviceType.getSelectedItemPosition()]), 
	        							   deviceName.getText().toString(), 
	        							   "",
	        							   1,
	        							   1);
	        
	        String replyString = socketDispatch.instance().sendReceive(new AddDeviceRequest(newDevice));
	        
	        String[] tokens = replyString.split(delimiter);
	        
	        TransactionReply addDeviceReply = gson.fromJson(tokens[1], TransactionReply.class);
	        
	        if (addDeviceReply.wasTransactionSuccessful())
	        {
	        	AlertDialog.Builder builder = new AlertDialog.Builder(AddDeviceActivity.this);
	        	builder.setMessage("Transaction Successful")
	        	       .setCancelable(false)
	        	       .setPositiveButton("OK", new DialogInterface.OnClickListener() {
	        	           public void onClick(DialogInterface dialog, int id) {
	        	        	   //RegisterDeviceActivity.this.finish();
	        	        	   //deviceType.setText("");
	        	               deviceName.setText("");
	        	               //zigbeeAddress.setText("");
	        	               //zigbeeStatus.setText("");
	        	               //deviceStatus.setText("");
	        	           }
	        	       });
	        	AlertDialog alert = builder.create();
	        	alert.show();
	        }
	        else
	        {
	        	AlertDialog.Builder builder = new AlertDialog.Builder(AddDeviceActivity.this);
	        	builder.setMessage("Transaction Failed")
	        	       .setCancelable(false)
	        	       .setPositiveButton("OK", new DialogInterface.OnClickListener() {
	        	           public void onClick(DialogInterface dialog, int id) {
	        	        	   //RegisterDeviceActivity.this.finish();
	        	           }
	        	       });
	        	AlertDialog alert = builder.create();
	        	alert.show();
	        }
    	}
  
//        db.open();
//        
//        long insertResult = db.insertDevice(newDevice);
//        Log.i("AddDeviceActivity: onClick", "Result of database insert is " + insertResult);
//        
//        
//        db.close();
            
        }
    };
	
}
